/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer.builtin;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_11659;
import net.minecraft.class_12245;
import net.minecraft.class_12247;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.builtin.TextureLayerGeoLayer;
import software.bernie.geckolib.util.RenderUtil;

public class AutoGlowingGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends TextureLayerGeoLayer<T, O, R> {
    private final Map<class_2960, class_2960> emissiveResourceCache = new Object2ObjectOpenHashMap();
    protected static final RenderPipeline RENDER_PIPELINE = class_10799.method_67887((RenderPipeline)EmissiveRenderType.createRenderPipeline());

    public AutoGlowingGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    @Override
    protected class_2960 getTextureResource(R renderState) {
        return this.emissiveResourceCache.computeIfAbsent(this.renderer.getTextureLocation(renderState), RenderUtil::getEmissiveResource);
    }

    protected boolean shouldRespectWorldLighting(R renderState) {
        return false;
    }

    protected boolean shouldAddZOffset(R renderState) {
        return this.getRenderer() instanceof GeoArmorRenderer;
    }

    protected int getBrightness(R renderState) {
        return 0xF00000;
    }

    @Override
    protected @Nullable class_1921 getRenderType(R renderState) {
        class_2960 texture = this.getTextureResource(renderState);
        boolean respectLighting = this.shouldRespectWorldLighting(renderState);
        boolean zOffset = this.shouldAddZOffset(renderState);
        if (!(renderState instanceof class_10017)) {
            return EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
        }
        class_10017 entityRenderState = (class_10017)renderState;
        boolean invisible = entityRenderState.field_53333;
        if (invisible && !renderState.getOrDefaultGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, false).booleanValue()) {
            return class_12249.method_75998((class_2960)texture);
        }
        if (entityRenderState.method_72997()) {
            if (invisible) {
                return class_12249.method_76018((class_2960)texture);
            }
            return EmissiveRenderType.getRenderType(texture, true, respectLighting, zOffset);
        }
        return invisible ? null : EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
    }

    @Override
    public void submitRenderTask(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        int packedLight = renderPassInfo.packedLight();
        renderPassInfo.renderState().addGeckolibData(DataTickets.PACKED_LIGHT, this.getBrightness(renderPassInfo.renderState()));
        super.submitRenderTask(renderPassInfo, renderTasks);
        renderPassInfo.renderState().addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
    }

    public static class EmissiveRenderType {
        private static final Map<Entry, class_1921> CACHE = new ConcurrentHashMap<Entry, class_1921>();

        public static class_1921 getRenderType(class_2960 texture, boolean outline, boolean respectLighting, boolean zOffset) {
            return CACHE.computeIfAbsent(new Entry(texture, outline, respectLighting, zOffset), EmissiveRenderType::buildNewInstance);
        }

        private static RenderPipeline createRenderPipeline() {
            return RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60128}).withLocation(GeckoLibConstants.id("pipeline/emissive")).withVertexShader("core/entity").withFragmentShader("core/entity").withShaderDefine("EMISSIVE").withShaderDefine("NO_OVERLAY").withShaderDefine("NO_CARDINAL_LIGHTING").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withDepthWrite(false).withCull(false).withVertexFormat(class_290.field_1580, VertexFormat.class_5596.field_27382).build();
        }

        private static class_1921 buildNewInstance(Entry entry) {
            class_12247.class_12248 builder = class_12247.method_75927((RenderPipeline)RENDER_PIPELINE).method_75934("Sampler0", entry.texture).method_75930(entry.zOffset ? class_12245.field_63976 : class_12245.field_63975).method_75932(entry.outline ? class_12247.class_4750.field_21855 : class_12247.class_4750.field_21853).method_75937();
            if (entry.respectLighting) {
                return class_1921.method_75940((String)"geckolib_entity_translucent_emissive", (class_12247)builder.method_75935().method_75936().method_75938());
            }
            return class_1921.method_75940((String)"geckolib_emissive", (class_12247)builder.method_75938());
        }

        public record Entry(class_2960 texture, boolean outline, boolean respectLighting, boolean zOffset) {
            @Override
            public int hashCode() {
                return Objects.hash(this.texture, this.outline, this.respectLighting, this.zOffset);
            }
        }
    }
}

